;								EJEMPLO 23
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El TMR1 en el modo contador ascendente de eventos externos
;
;Mediante el generador de onda cuadrada del laboratorio  se aplican pulsos por la 
;lnea RC0/T1CKI. La pantalla LCD visualizar, en binario, el contenido del TMR1
;
;Si se selecciona una muy baja frecuencia en el generador (1H aprox.), se puede apreciar 
;claramente que los incrementos del contador se producen en los flancos ascendentes de la
;seal de onda cuadrada.

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Lcd_var		equ	0x20		;Inicio de variables de las rutinas LCD
Temporal_1	equ	0x22		;Variable temporal
Temporal_2	equ	0x23		;variable temporal

			org	0x00				;Vector de RESET	
			goto	Inicio
			org	0x05

			include	"LCD_CXX.INC"	;Incluye rutinas de manejo del LCD

;Visualiza: Esta rutina coge el octeto presente en la variable Temporal_1, lo convierte
;a 8 caracteres ASCII (0 o 1) y los visualiza sobre el LCD

Visualiza:		movlw	.8
				movwf	Temporal_2		;N de caracteres a visualizar
Visual_loop		rlf		Temporal_1,F
				btfsc	STATUS,C		;Testea el bit a visualizar
				goto	Bit_1			;Est a 1
				movlw	'0'
				goto	Visu_1
Bit_1			movlw	'1'
Visu_1			call	LCD_DATO		;Visualiza el "0" o el "1" sobre el LCD
				decfsz	Temporal_2,F	;Siguiente bit/carcter
				goto	Visual_loop
				return
		
;Programa principal

Inicio	       	bsf		STATUS,RP0		;Selecciona banco 1
				movlw	0x06
				movwf	ADCON1			;Puerta A digital
				movlw	b'11111111'	
				movwf	TRISC			;Puerta C como entrada
				bcf		STATUS,RP0		;Selecciona banco 0

;El TMR1 acta como contador externo asncrono y con un preescaler de 1:1

				clrf	TMR1L
				clrf	TMR1H			;Puesta a 0 del TMR1
				movlw	b'00000011'
				movwf	T1CON			;Configura TMR1 en modo contador
				call	UP_LCD			;Configura puerto para el LCD
				call	LCD_INI			;Inicia el LCD
				movlw	b'00001100'
				call	LCD_REG			;LCD On, cursor y blink Off
	
Loop			movlw	0x80
				call	LCD_REG			;Cursor home
				movf	TMR1H,W
				movwf	Temporal_1		;Lee byte alto del TMR1
				call	Visualiza		;Visualiza en binario
				movf	TMR1L,W
				movwf	Temporal_1		;Lee byte bajo del TMR1
				call	Visualiza		;Visualiza en binario

				goto	Loop			;Bucle infinito		

				end						;Fin del programa fuente
